﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminEditReferenceRange.aspx.cs" Inherits="AdminEditReferenceRange" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Administration > Reference Ranges > "/>
    </div>    

    <!--
    <asp:Label SkinID="DataLabel" ID="LabelforTextBoxLastName" runat="server" AssociatedControlID="TextBoxLastName">Last Name:</asp:Label>
                        
    <br />
    <asp:TextBox ID="TextBoxLastName" runat="server" MaxLength="40" Text="" 
        Width="200px" />
    <br />
    -->

    <asp:FormView ID="FormViewReferenceRange" runat="server" 
        DataSourceID="ObjectDataSourceReferenceRange" DefaultMode="Edit" 
        ondatabound="FormViewReferenceRange_DataBound">
        <EditItemTemplate>
            <table>
                <tr>
                    <td><asp:Label ID="LabelForTestName" runat="server" Text="Test Name" AssociatedControlID="LabelTestName" SkinID = "DataLabel"></asp:Label></td>
                    <td><asp:Label ID = "LabelTestName" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("TestName")), false) %>' SkinID = "DataLabel"></asp:Label></td>
                </tr>
                <tr>
                    <td><asp:Label ID="LabelForAnalyteName" runat="server" Text="Analyte Name" AssociatedControlID="LabelAnalyteName" SkinID = "DataLabel"></asp:Label></td>
                    <td><asp:Label ID = "LabelAnalyteName" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("AnalyteName")), false) %>' SkinID = "DataLabel"></asp:Label></td>
                </tr>
                <tr>
                    <td><asp:Label SkinID="DataLabel" ID="LabelTEFSCReferenceRange" runat="server" Text="TEFSC Reference Range" AssociatedControlID="TextBoxTEFSCReferenceRange"></asp:Label></td>
                    <td><asp:TextBox ID="TextBoxTEFSCReferenceRange" runat="server" Text='<%# Bind("TEFSCReferenceRange") %>' /></td>
                </tr>
                <tr>
                    <td><asp:Label SkinID="DataLabel" ID="LabelUnit" runat="server" Text="Unit" AssociatedControlID="DropDownListUnit"></asp:Label></td>
                    <td><asp:DropDownList SelectedValue='<%# Bind("UnitID") %>' ID="DropDownListUnit" runat="server" DataSourceID="ObjectDataSourceUnit" DataTextField="Value" DataValueField="Key" ></asp:DropDownList></td>
                </tr>
            </table>
            <asp:HiddenField ID="HiddenFieldID" runat="server" Value='<%# Bind("ID") %>' />
            <asp:HiddenField ID="HiddenFieldUnitName" runat="server" Value='<%# Bind("UnitName") %>' />

            <asp:Button ID="UpdateButton" runat="server" CausesValidation="True" 
                CommandName="Update" Text="Update" />
            &nbsp;<asp:Button OnClick="UpdateCancelButton_Click" ID="UpdateCancelButton" runat="server" 
                CausesValidation="False" CommandName="Cancel" Text="Cancel" />
        </EditItemTemplate>
    </asp:FormView>

    <asp:ObjectDataSource ID="ObjectDataSourceUnit" runat="server" 
        OldValuesParameterFormatString="original_{0}" 
        SelectMethod="GetBiomionitoringTestUnits" 
        TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
    </asp:ObjectDataSource>


    <asp:ObjectDataSource ID="ObjectDataSourceReferenceRange" runat="server" 
        DataObjectTypeName="VeteransAffairs.Registries.BusinessManager.ReferenceRangeManager+ReferenceRangeView" 
        OldValuesParameterFormatString="original_{0}" 
        SelectMethod="SelectReferenceRangeByID" 
        TypeName="VeteransAffairs.Registries.BusinessManager.ReferenceRangeManager" 
        UpdateMethod="UpdateReferenceRange" 
        onupdated="ObjectDataSourceReferenceRange_Updated">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="ID" QueryStringField="ID" 
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>

</asp:Content>

